/* FtpLog.java

        Purpose: To facilitate debug output and general logging

        History:

        08-16-98        rw      Created


*/
/**
        The FTPLog class facilitates general logging (such as transfer statistics),
        error logging, and debug logging.

        Currently, all output goes to stdout.

*/

public class FTPLog {


/**
        How much detail to include in debug output (<B>NYI</B>)
*/
        private int     DebugLevel;
/**
        How much detail to include in general log output (<B>NYI</B>)
*/
        int     LogLevel;

        public FTPLog (){
                DebugLevel = 0;
                LogLevel = 0;
                return;
        }

        public void SetLogLevel (int Level){
                LogLevel = Level;
        }

        public void SetDebugLevel (int Level){
                DebugLevel = Level;
        }

/**
       Record a file transfer to the log (<B>NYI</B>)
       @param File The name of the file transfered, including path
       @param Bytes The size of the file in bytes
       @param Seconds How many seconds the file transfer took
 */
        public void LogTransfer (String File, long Bytes, long Seconds){
                return;
        }

/**
        A general purpose logging mechanism.
*/
        public void LogMsg (String Message){
                System.out.println (Message);
                return;
        }

/**
        A general purpose debugging mechanism.
*/
        public void DebugMsg (String s){
                System.out.println (s);
                return;
        }
}
