/* FTPCommand.java

        Purpose: To implement and encapsulate the FTP RFC 959 commands

        History:

        08-16-98        rw      Created


*/
import java.util.StringTokenizer;

/** The FTPCommand class encapsulates our implementation of RFC 959.
*/

public class FTPCommand  {

/** A Connection object for performing communications, etc.
@see Connection
*/
        private Connection      CurrentConnection;
/** The current FTP command (such as USER PASS DELE)
*/
        private String          Command;
/** Any arguements to the Command
*/
        private String          Args[];
/** The numeric result code (such as 220) according to the RFC
*/
        private int             Result;
/** Any textual message to be sent with the response.
*/
        private String          ResultMsg;

        public FTPCommand (){
        }

/** Stores and parse the current command string.  Must be called before
any other methods.
*/
        public void SetCommandString (String CommandString){
                StringTokenizer Tokenizer = new StringTokenizer (CommandString, " \n\r", false);

                Args = new String[Tokenizer.countTokens() - 1];

                Command = Tokenizer.nextToken().toUpperCase();

                int TokenIndex = 0;
                while (Tokenizer.hasMoreTokens()){
                        Args[TokenIndex] = Tokenizer.nextToken();
                        TokenIndex++;
                }

                return;
        }

        public String toString (){
                return Command;
        }

/** Executes the appropriate method for the given command.
*/
        public void run(){

                if (Command.equals("USER")){
                } else if (Command.equals("PASS")){
                } else {
                        FTPUnknownCommand();
                }
                return;
        }

/** Called when an unknown or unimplemented command is requested
*/
        void FTPUnknownCommand (){
                return;
        }

/** Sends the result of the command to the user via the CurrentConnection.
@param Code numeric result code
@param Message any text corresponding to the numeric result code
*/
        void SendResponse (int Code, String Message){
                CurrentConnection.SendResponse (Code.toString() + " " + Message);
                return;
        }
}

