/* Connection.java

        To maintain information about an FTP Connection

        History:

        08-16-98        rw      Created


*/
import java.lang.Thread;

/** The Connection class is responsible for handling the interaction of
each user connection
*/
public class Connection extends Thread {

/** The current Client communcation object
*/
        private Communication Client;
/** The current command being requested
*/
        private FTPCommand      Command;

        private FTPLog          Log;
        private User            CurrentUser;
        private String          CurrentDirectory;
/* Current Stats.  Stat Object? */
        private boolean         LoggedIn;

        public Connection (Communication ClientConnection) {
                Client = ClientConnection;
                Log = new FTPLog ();
                Log.LogMessage ("Using Client: " + Client.toString());
                Command = null;
        }
/** The main loop for the client communication.  Loops until the connection
is broken, waiting for commands, then executing them.
*/
        public void run (){
                Log.LogMessage ("Running client connection");

                while (Client.IsAlive()){
                        Command = Client.GetCommand();
                        if (Command != null){
                                Log.LogMessage (Command.toString());
                                Command.run ();
                        } else {
                                Log.LogMessage ("NULL Command");
                        }
                }
                return;
        }
}
