
/* Communication.java

        Purpose: To abstract FTP Commands over sockets

        History:

        08-16-98        rw      Created


*/
import java.net.*;
import java.io.*;

/**
        The Communication class permits communication over sockets

*/

public class Communication  {

/** The socket used for communications with the client.
*/
        private Socket                  Client;
/** The socket used for data transmission with the client.
*/
        private Socket                  Data;
        private FTPLog                  Log;
/** Constant used for parsing input */
        static  final           int     FTP_NEWLINE = 13;

        public Communication (){
                Client = null;
                Data = null;
                Log = new FTPLog();
        }

        public Communication (Socket ClientSocket){
                Log = new FTPLog ();
                Client = ClientSocket;
                Log.LogMessage ("Using " + Client.toString());
                Data = null;
        }

/** Waits for a command from the user.  Creates a new FTPCommand object
and returns the command inside of it.
*/
        public FTPCommand GetCommand (){
                InputStream    SocketInputStream;
                FTPCommand      NewCommand = new FTPCommand();

                try {
                        SocketInputStream = Client.getInputStream();
                        StringBuffer            InputString = new StringBuffer();
                        int                     InputByte = 0;

                        while (InputByte != FTP_NEWLINE){
                                InputByte = SocketInputStream.read();
                                InputString.append(String.valueOf((char)InputByte));
                        }
                        NewCommand.SetCommandString (InputString.toString());
                } catch (IOException ioe){
                        Log.LogMessage ("IOException: " + ioe.toString());
                }

                return NewCommand;
        }
/**Sends an arbitrary string to the client */
        public void SendResponse (String Response){
                OutputStream    SocketOutputStream;
                try {
                        SocketOutputStream = Client.getOutputStream();
                        SocketOutputStream.write (Response.getBytes());
                } catch (IOException ioe){
                        Log.LogMessage ("IOExceptio: " + ioe.toString());
                }
                return;
        }
/** Verifies the current connection is still valid.
*/
        public boolean IsAlive(){
                Log.LogAction ("IsAlive()->true");
                return true;
        }
/** Sets the data socket (such as in response to a PORT command) */
        public void SetDataSocket (Socket DataSocket){
                Data = DataSocket;
        }

}
