/* ChangeStrX */
ChangeStrX:  Procedure   ;

PARSE UPPER ARG    .  ,   .  ,    .    ,  ,
                 flags  ,
             =1  . 'I' +0 ignorecase , ,
                 count1, count2,  .   ;
PARSE  ARG  oldneedle, haystack, newneedle,  .  ;

/* This version is to change instances inclusively between
   count1 and count2 of the old needle string.
   The mere addition of only one more number, count2,
   seems to cause an explosion in the number
   of possible 'wrong' input value combinations
   demanding possible interpetation.
   I try putting some spin on these here, but other people
   may have different, and proabably better ideas.
   Maybe anything other than
   0 < count1 < count2
   should simply be dismissed as an error and pitched out!
*/

IF  '' = oldneedle  THEN
  RETURN  haystack  ;

ignorecase  =  '' << ignorecase  ;   /*  Booleanate the value */

IF  '' = count1   THEN
  IF  '' = count2   THEN
    Return ChangeStr( oldneedle, haystack, newneedle, flags )  ;
                    /*  otherwise change all, (and
                        re-use previous function. :-) )
                     */
  ELSE
    count1  =  0  ;

IF  '' = count2  THEN
  count2  =  CountStr( oldneedle, haystack, flags )  ;
  /*  Set it to go past the end of haystack  */

IF  0 > count2  THEN
  IF  0 > count1  THEN
    DO
    counta  =  -count1  ;
    countb  =  -count2  ;
    count1  =  Min( counta, countb )  ;
    count2  =  Max( counta, countb )  ;
    /*  Conservatively convert this into a call to this same function,
        counting needles in haystack from the end of the haystack string.
    */
    oldneedle     =  Reverse( oldneedle )  ;
    haystack      =  Reverse( haystack )  ;
    newneedle     =  Reverse( newneedle )  ;
    RETURN  ,
      Reverse(  ChangeStrX( oldneedle, haystack, ,
                  newneedle, flags, count1, count2 ) )  ;
    END
  ELSE     /* 0 < count1, use count2 ( < 0 ) as count from end,
                 Perl/Python style  */
    DO
    count2  =  CountStr( oldneedle, haystack, flags ) + count2 + 1  ;
    RETURN  ,
      ChangeStrX( oldneedle, haystack, newneedle, flags, count1, count2 )  ;
    END

/*  This is left in just to document my thinking on this case:
IF  0 > count1  THEN
  DO
  NOP  ;
  /* at this point, count2 must be greater than zero, so I will assume
     count1 is just trying to start early.
  */
  END
*/

IF  count2 < count1  THEN
  DO
  /*  Here, assume a wrap around effect, leaving the middle unchanged */
  haystack  =  ChangeCnt( oldneedle, haystack, newneedle, flags, count2 )  ;
  count1  =  count1 - CountStr( oldneedle, haystack, flags )
  RETURN  ChangeCnt( oldneedle, haystack, newneedle, flags, count1 )  ;
  END

/* Enough already!

   The alternative:
   IF  0 > count1 | count1 > count2  THEN
     CALL SomeTrapHere.....

   On with the basic processing, and forget about any other special
   count1/count2 relations.
   From here on out, it is assumed that
   0 < count1 < count2
*/


/*  First lets count how many instances are going to be replaced  */
/*  This could be inlined here if neccessary:  */
total  =  CountStr( oldneedle, haystack, flags )  ;

IF  total < count1  THEN
  RETURN  haystack  ;

total  =  Min( total, count2 )  ;

/*  Now the meat and potato loops processing the haystack string.
    Same as above function.
*/
IF  ignorecase  THEN
       /* To really understand this, study the case sensitive branch below */
  DO
  lneedle  =  Length( oldneedle )  ;
  PARSE UPPER VAR  oldneedle  tneedle  ;
  PARSE UPPER VAR haystack  outstring (tneedle) .  ;
  spot  =  Length( outstring'#' )   ;
  /*  -  append another character rather than add 1 after
         calculating length
   */
  PARSE VAR haystack  . =(spot) pneedle +(lneedle) haystack  ,
                  =1  outstring (pneedle) .  ;
  /*  PARSE contortions needed in case needle is at the front
      of haystack, in which case =(spot) would squeeze '.'
      (or 'outstring' in fact if the simple case were being tried.)
      to hold all of original haystack string, which would be wrong.
      This case would be wrong if outstring were the empty string (''),
      that is pneedle were at the front of haystack:
      'PARSE VAR haystack  outstring =(spot) pneedle +(lneedle) haystack  ;'
   */
  DO  instance = 1  TO total
    SELECT
    WHEN  instance = count2  THEN
      RETURN  outstring || newneedle || haystack  ;
    WHEN  count1 <= instance  THEN
      outstring  =  outstring || newneedle  ;
    OTHERWISE
      outstring  =  outstring || pneedle  ;
    END
    PARSE UPPER VAR haystack  increment (tneedle) .  ;
    spot  =  Length( increment'#' )   ;
    PARSE VAR haystack  . =(spot) pneedle +(lneedle) haystack  ,
                    =1  increment (pneedle) .  ;
    outstring  =  outstring || increment  ;
  END    /*  WHILE  */  ;
  END    /*  IF  */  ;
ELSE              /* Use Case (case sensitive)  */
                  /*  This branch is simpler to understand  */
  DO
  PARSE VAR haystack  outstring (oldneedle) haystack  ;
  DO  instance = 1  TO total
    SELECT
    WHEN  instance = count2  THEN
      /*  Now, go ahead and end this invocation of this function,
          since 'count' has been reached.
      */
      RETURN  outstring || newneedle ||  haystack  ;
    WHEN  count1 <= instance  THEN
      outstring  =  outstring || newneedle  ;
    OTHERWISE
      outstring  =  outstring || oldneedle  ;
    END
    PARSE VAR haystack  increment (oldneedle) haystack  ;
    outstring  =  outstring || increment  ;
    /*  - Need a seperate string to store eventual output,
        incase new needle is a substring of old needle,
        which would cause an infinit loop.
     */
  END    /*  WHILE  */  ;
  END    /*  ELSE  */  ;

RETURN  outstring  ;