/* ChangeStr */
ChangeStr:  Procedure   ;

PARSE UPPER ARG    .   ,  .  ,  .    ,  flags =1  . 'I' +0 ignorecase ,  .  ;
ignorecase  =  '' << ignorecase  ;   /*  Booleanate the value */

PARSE  ARG  oldneedle, haystack, newneedle,   .   ;

IF  '' = oldneedle  THEN
  RETURN haystack  ;
/*  Alternate interpretations would be for putting newneedle
    inbetween each character of haystack (where zero length strings
    exist in the interstices :-) of the string.)
    Or one newneedle at the end of haystack,
    where parse interprets '' to be.
*/

/*  First, try to handle a cheap case:  */
IF  1 = Length( oldneedle )  THEN
  IF  1 = Length( newneedle )  THEN
    DO
    IF  ignorecase  THEN
      DO
      lowers  =  XRange( 'a', 'z' )  ;
      IF  0 < Pos( oldneedle, lowers )  THEN
        DO
        newneedle  =  newneedle || newneedle  ;
        oldneedle  =  oldneedle || Translate( oldneedle )  ;
        END
      ELSE      /*  not a lower case letter  */
        DO
        upper  =  Pos( oldneedle, XRange( 'A', 'Z' ) )  ;
        IF  0 < upper  THEN
          DO
          newneedle  =  newneedle || newneedle  ;
          oldneedle  =  oldneedle || SubStr( lowers, upper, 1 )  ;
          END  ;  /*  is upper case  */
        END  ;  /*  non-lower case  */
      END  ;   /*  ignore case  */

    RETURN  Translate( haystack, newneedle, oldneedle )  ;
    END  ;  /*  both needles a single character  */

/* First let's count how many instances are going to be replaced  */
/*  This could be inlined here if neccessary:  */
total  =  CountStr( oldneedle, haystack, flags )  ;

IF  ignorecase  THEN
  DO
  lneedle  =  Length( oldneedle )  ;
  PARSE UPPER ARG   uneedle  ;
  PARSE UPPER VAR  haystack  outstring (uneedle) .  ;
  spot  =  Length( outstring'#' )   ;
  /*  -  append another character rather than add 1 after
         calculating length
   */
  PARSE VAR haystack  . =(spot) pneedle +(lneedle) haystack  ,
                  =1  outstring (pneedle) .  ;
  DO  total
    outstring  =  outstring || newneedle  ;
    PARSE UPPER VAR haystack  increment (uneedle) .  ;
    spot  =  Length( increment'#' )   ;
    PARSE VAR haystack  . =(spot) pneedle +(lneedle) haystack  ,
                    =1  increment (pneedle) .  ;
    outstring  =  outstring || increment  ;
  END    /*  WHILE  */  ;
  END    /*  IF  */  ;
ELSE              /* use case  */
  DO              /* this branch is simpler to understand, but still
                     mirrors the steps in the branch (case insensitive)
                     above
                   */
  PARSE VAR haystack  outstring (oldneedle) haystack  ;
  DO  total
    outstring  =  outstring || newneedle  ;
    PARSE VAR haystack  increment (oldneedle) haystack  ;
    outstring  =  outstring || increment  ;
    /*  - Need a seperate string to store eventual output,
        incase old needle is a substring of new needle,
        which would cause an infinite loop.
     */
  END    /*  WHILE  */  ;
  END    /*  ELSE  */  ;

/* To some extent, haystack and outstring function as a stacks,
   allowing the shift of the character data from the structure for
   input to the structure for output.
   From this point of view, this demonstrates the ability to
   use data stacks to replace recursive program flow.
*/

RETURN  outstring  ;
