/* ChangeCnt */
ChangeCnt:  Procedure   ;

PARSE UPPER ARG      .  ,     .  ,    .  ,  flags  ,
             =1  . 'I' +0 ignorecase ,
             =1  . 'O' +0 onlyone    , ,
                 count , .  ;
PARSE       ARG   oldneedle,  haystack,  newneedle,  .  ;

/*
'Change Count' - change the number of needles in haystack
                 This variant has so many add-ons that continuing to call
                 it ChangeStr seemed a misrepresentation.
                 Also, at some points it bails out to the original
                 ChangeStr to do the job.

Usage:  ChangeCnt( oldneedle, haystack, newneedle, [-i] [-o], [count] )

     oldneedle  =  original substring
     haystack   =  original string
     newneedle  =  replacement substring
     -i         =  ignore case
     -o         =  'only one', count is ordinal instead of cardinal:
                     3 means third, not first three,
                     5 means fifth, not first five, etc.
     count      =  number of oldneedles to change to newneedles
                   3 would change only first 3, even if there were more
                   than 3 (say, 5 for example) oldneedles in haystack.
                   If count < 0, then oldneedles are counted from the
                   end instead of the beginning of the haystack string.
                   (like in Perl or Python.)
                   Count defaults to all, unless '-o' flag is given,
                   then defaults to 1.
*/

IF  '' = oldneedle  THEN
  RETURN haystack  ;

ignorecase  =  '' << ignorecase  ;   /*  Booleanate the value */
onlyone     =  '' << onlyone     ;
/*  Normally, 'onlyone' indicates that 'count' is 'ordinal', not
    'cardinal'.
    That is, 2 indicates 2nd instance, not the first 2,
    5 would indicate the 5th instance, not the first 5, etc.
*/


If  '' = count  THEN
  IF  onlyone  THEN
    count  =  1  ;  /*  if no count given, but 'only one' flagged,
                        do first needle  */
  ELSE
    Return ChangeStr( oldneedle, haystack, newneedle, flags )  ;
                    /*  otherwise change all, (and
                        re-use previous function. :-) )
                     */

IF  0 > count  THEN
  DO
  /*  Conservatively convert this into a call to this same function,
      counting needles in haystack from the end of the haystack string.
  */
  oldneedle     =  Reverse( oldneedle )  ;
  haystack      =  Reverse( haystack )  ;
  newneedle     =  Reverse( newneedle )  ;
  Return  ,
    Reverse(  ChangeCnt( oldneedle, haystack, newneedle, flags, -count ) )  ;
  END

IF  0 = count  THEN
  RETURN  haystack  ;
/*  - the alternative would be for 0 count to mean do all cases,
      in which the above IF/RETURN should be commented out.
      because the below loops will not stop till all oldneedles
      are changed to newneedles.
*/


/*  First lets count how many instances are going to be replaced  */
/*  This could be inlined here if neccessary:  */
total  =  CountStr( oldneedle, haystack, flags )  ;

IF total < count  THEN
  DO
  IF onlyone  THEN
    RETURN  haystack  ;
  count  =  total  ;
  END
/*    -- just in case count is greater than the total number of
         instances of the oldneedle string.
*/


/*  Now the meat and potato loops processing the haystack string.
    Handle the case insensitive and case sensitive options in
    seperate branches of an IF statement, so that case sensitive
    isn't slowed down by the extra processing needed for case
    insensitivity.
*/


IF  ignorecase  THEN
       /* To really understand this, study the case sensitive branch below */
  DO
  lneedle  =  Length( oldneedle )  ;
  PARSE UPPER VAR  oldneedle  tneedle  ;
  PARSE UPPER VAR haystack  outstring (tneedle) .  ;
  spot  =  Length( outstring'#' )   ;
  /*  -  append another character rather than add 1 after
         calculating length
   */
  PARSE VAR haystack  . =(spot) pneedle +(lneedle) haystack  ,
                  =1  outstring (pneedle) .  ;
  /*  PARSE contortions needed in case needle is at the front
      of haystack, in which case =(spot) would squeeze '.'
      (or 'outstring' in fact if the simple case were being tried.)
      to hold all of original haystack string, which would be wrong.
      This case would be wrong if outstring were the empty string (''),
      that is pneedle were at the front of haystack:
      'PARSE VAR haystack  outstring =(spot) pneedle +(lneedle) haystack  ;'
   */
  DO  instance = 1  TO total
    SELECT
    WHEN  instance = count  THEN
      RETURN  outstring || newneedle || haystack  ;
    WHEN  onlyone  THEN
      outstring  =  outstring || pneedle  ;
    OTHERWISE
      outstring  =  outstring || newneedle  ;
    END
    PARSE UPPER VAR haystack  increment (tneedle) .  ;
    spot  =  Length( increment'#' )   ;
    PARSE VAR haystack  . =(spot) pneedle +(lneedle) haystack  ,
                    =1  increment (pneedle) .  ;
    outstring  =  outstring || increment  ;
  END    /*  WHILE  */  ;
  END    /*  IF  */  ;
ELSE              /* Use Case (case sensitive)  */
                  /*  This branch is simpler to understand  */
  DO
  PARSE VAR haystack  outstring (oldneedle) haystack  ;
  DO  instance = 1  TO total
    SELECT
    WHEN  instance = count  THEN
      RETURN  outstring || newneedle || haystack  ;
    WHEN  onlyone  THEN
      outstring  =  outstring || oldneedle  ;
    OTHERWISE
      outstring  =  outstring || newneedle  ;
    END
    PARSE VAR haystack  increment (oldneedle) haystack  ;
    outstring  =  outstring || increment  ;
  END    /*  WHILE  */  ;
  END    /*  ELSE  */  ;

RETURN  outstring  ;
