/* install XFolder */
/* (w) (c) 1998 Ulrich Mller */

'@echo off'
signal on halt; trace off

call RxFuncAdd 'SysLoadFuncs', 'REXXUTIL', 'SysLoadFuncs'
call SysLoadFuncs

parse source mydir;
parse var mydir x1 x2 mydir;
mydir = filespec("D", mydir)||filespec("P", mydir);
if (right(mydir, 1) = "\") then
    mydir = left(mydir, length(mydir)-1);

nl = '0a0d'x;
IniKey = "XFolder07";

foundList.0 = 0

parse arg args

if (args \= "") then
    LanguageCode = args;
else do
    do
        langloop:
        MsgFiles.0 = 0;
        Say ""
        rc = SysFileTree(mydir"\bin\*.msg", "MsgFiles", "FO");
        if (msgFiles.0 = 0) then do
            Say ""
            Say "The XFolder install program was unable to find any of its language"
            Say "files. Either the ZIP file you downloaded has been damaged or you"
            Say "did not unzip it properly. There must be a subdirectory BIN under"
            Say "the directory where the INSTALL.CMD script resides."
            Say "With InfoZIP, use:           unzip xfldr.zip"
            Say "With PkZIP, use:             pkzip /extract /directories xfldr.zip"
            "pause > nul"
            exit
        end
        else if (MsgFiles.0 = 1) then do
            fname = filespec("NAME", MsgFiles.1);
            LanguageCode = substr(fname, 5, 3)
            signal begin
        end
        else do
            do i = 1 to MsgFiles.0
                fname = filespec("NAME", MsgFiles.i);
                "call bin\xhelp -F bin\"fname" IdentifyMsg"
            end

            Say ""
            call charout , ">>"
            parse pull LanguageCode

            if (stream("bin\inst"LanguageCode".msg", "c", "QUERY EXISTS") = "") then do
                say "This is not a valid language code.";
                signal langloop
            end
        end;
    end;
end

begin:
callxhelpStr = "call bin\xhelp -F bin\inst"LanguageCode".msg"

cls

callxhelpStr "welcomeMsg"
call pause

loop:
callxhelpStr "queryActionMsg"
key = ''
do until (pos(key,"RDX") > 0)
   key = translate(SysGetKey("NOECHO"))
end /* do */
Say key

select
    when (key = "R") then do

        /* REGISTER */

        rc = SysINI('USER', "XFolder", "DELETE:");
        rc = SysINI('USER', "XFolder_0_40", "DELETE:");
        rc = SysINI('USER', "XFolder_0_41", "DELETE:");
        rc = SysINI('USER', "XFolder_0_42", "DELETE:");
        rc = SysINI('USER', "XFolder 0.5x", "DELETE:");
        rc = SysINI('USER', IniKey, "XFolderPath", mydir"\bin"||'0'x);
        rc = SysINI('USER', IniKey, "Language", LanguageCode||'0'x);
        rc = SysINI('USER', IniKey, "JustInstalled", '1'||'0'x);
        rc = SysINI('USER', IniKey, "GlobalSettings", "DELETE:");
        rc = SysINI('USER', IniKey, "Accelerators", "DELETE:");

        callxhelpStr "unregisteringOldMsg";
        "bin\repclass.exe WPDesktop XFldDesktop"
        "bin\repclass.exe WPDisk XFldDisk"
        "bin\repclass.exe WPFolder XFolder"
        "bin\repclass.exe WPSystem XFldSystem"
        "bin\repclass.exe WPObject XFldObject"
        say "";
        callxhelpStr "registeringNewMsg";
        "bin\repclass.exe WPFolder XFolder" mydir||"\bin\xfldr.dll";
        "bin\repclass.exe WPDesktop XFldDesktop" mydir||"\bin\xfldr.dll";
        "bin\repclass.exe WPSystem XFldSystem" mydir||"\bin\xfldr.dll";
        "bin\repclass.exe WPDisk XFldDisk" mydir||"\bin\xfldr.dll";
        "bin\repclass.exe WPObject XFldObject" mydir||"\bin\xfldr.dll";
        say "";

        call SysQueryClassList "ClassList.";
        do i = 1 to ClassList.0
            parse var ClassList.i Class DLL
            if (Class = "TSEnhFolder") then do
                callxhelpStr "QueryODMsg";
                key = ''
                do until (pos(key,"YN") > 0)
                   key = translate(SysGetKey("NOECHO"))
                end;
                say key;
                say "";
                if (key = "Y") then do
                    if (SysDeregisterObjectClass("TSEnhFolder") = 1) then do
                        call SysRegisterObjectClass "TSEnhFolder", "OBJDEFLD";
                        callxhelpStr "ODDeregdMsg";
                        "pause >NUL"
                    end;
                end;
            end;
        end

        callxhelpStr "shutdownMsg";
        key = ''
        do until (pos(key,"YN") > 0)
           key = translate(SysGetKey("NOECHO"))
        end /* do */
        Say key
        if (key = "Y") then
            "bin\wpsreset -D"
        else do
            callxhelpStr "howtoMsg";
            "pause >NUL"
        end
        exit
    end

    when (key = "D") then do
        /* UNREGISTER */

        callxhelpStr "unregisteringOldMsg";
        "bin\repclass.exe WPFolder XFolder"
        "bin\repclass.exe WPDesktop XFldDesktop"
        "bin\repclass.exe WPDisk XFldDisk"
        "bin\repclass.exe WPObject XFldObject"
        "bin\repclass.exe WPSystem XFldSystem"

        say "";
        callxhelpStr "removeIniMsg";
        key = ''
        do until (pos(key,"YN") > 0)
           key = translate(SysGetKey("NOECHO"))
        end /* do */
        Say key
        if (key = "Y") then do
            rc = SysINI('USER', IniKey, "DELETE:");
            MMINI = GetBootDrive()||"\MMOS2\MMPM.INI";
            rc = SysINI(MMINI, "MMPM2_AlarmSounds", "555", "DELETE:");
            rc = SysINI(MMINI, "MMPM2_AlarmSounds", "556", "DELETE:");
            rc = SysINI(MMINI, "MMPM2_AlarmSounds", "558", "DELETE:");
            rc = SysINI(MMINI, "MMPM2_AlarmSounds", "559", "DELETE:");
            rc = SysINI(MMINI, "MMPM2_AlarmSounds", "560", "DELETE:");
        end;

        say "";
        callxhelpStr "shutdownMsg";
        key = ''
        do until (pos(key,"YN") > 0)
           key = translate(SysGetKey("NOECHO"))
        end /* do */
        Say key
        if (key = "Y") then
            "bin\wpsreset -D"
        exit
    end;
/*    when (key = "O") then do
        call createObjects;
        callxhelpStr "createObjDoneMsg";
        callxhelpStr "exitMsg";
        "pause > NUL";
        exit
    end; */
    when (key = "X") then
        exit;
end /* select */

say ""

signal loop;

halt:
say '0d0a'x'Installation aborted!'
exit

createObjects:
        callxhelpStr "creatingObjMsg"
        "call bin\crobj"LanguageCode".cmd"
return;

queryDir:
    callxhelpStr "dirPauseMsg"
    call pause

    callxhelpStr "foundDirsMsg"
    say arg(2)":"

    path. = ""
    path2 = arg(1)
    i = 1
    do while (path2 \= "")
        parse var path2 path3 ";" path2
        say format(i,4)||":" path3
        path.i = path3
        i=i+1
    end
    callxhelpStr "xAskMeMsg"
    path.0 = i-1
    callxhelpStr "enterNumberQuery"
    repeat:
    parse pull _dir
    if \((_dir = "x") | ((_dir > 0) & (_dir <= path.0))) then do
        callxhelpStr "invalidMsg"
        signal repeat
    end
    if (_dir = "x") then do
        callxhelpStr "enterFullQuery"
        parse pull dir
    end
    else dir = path._dir
    say dir
return dir

GetBootDrive: procedure
    parse upper value VALUE( "PATH",, "OS2ENVIRONMENT" ) with "\OS2\SYSTEM" -2 boot_drive +2
return boot_drive

GetLibPath: procedure
   bootDrive = GetBootDrive()
   thisRC = 0
   if bootDrive <> "" then do
                     /* get the LIBPATH value                          */
     configSys = left( bootDrive,1 ) || ":\CONFIG.SYS"
     lineSeparator = "0D0A"x
     libpathStmt = lineSeparator || "LIBPATH="

     if (stream( configSys, "c", "QUERY EXIST" ) <> "") then do
       configSysLength = chars( configSys )
       call stream configSys, "c", "OPEN READ"
       configSYS_ = CharIn( configSys, 1, configSysLength )
       call stream configSys, "c", "CLOSE"
       parse upper var ConfigSYS_ . (libPathStmt) LIBPATH (lineSeparator) .
       LIBPATH = strip( LIBPATH )
     end
     else
       thisRC = -1
    end
return LIBPATH

checkdir:
    if translate(directory(arg(1))) \= translate(arg(1)) then do
        call charout ,"Creating target directory... "
        'md' arg(1)
        say "Done."
    end
return

searchPath:
    leftPath = arg(1)
    sFile = arg(2)
    do while leftPath \= ""
        parse var leftPath curpath ";" leftPath
        if (stream(curpath"\"sFile,'c','query exists') \= "") & (curPath \= "") & (curPath \= ".") & (curPath \= mydir) then
            return curpath"\"sFile
    end
return 0

filesExist:
    rc = sysFileTree(arg(1), installFiles)
    searchPath = arg(2)
    curdir_ = mydir
    do i = 1 to installFiles.0
        parse var installFiles.i fdate ftime fsize fattr fname
        fname = filespec('NAME', fname)
        found = SearchPath(searchPath, fname)
        if (found \= "") then do
            fpath = filespec('D', found)||filespec('PATH', found)
            if fpath = "" then leave
            found2 = 0
            do j = 1 to foundList.0
                if foundList.j = fpath then
                    found2 = j
            end
            if (found2 = 0) then do
                k = foundList.0 + 1
                foundList.k = fpath
                foundList.k.0 = 1
                foundList.k.1 = fname
                foundList.0 = k
            end
            else do
                k2 = foundList.found2.0 + 1
                foundList.found2.0 = k2
                foundList.found2.k2 = fname
            end
        end
    end
return (foundList.0 > 0)

pause:  procedure
key = ""
do while (key = "")
   key = SysGetKey("NOECHO")
end /* do */
say ""
return

strReplace: procedure
    /* syntax: result = strReplace(str, old, new) */
    /* will replace a by b in oldstr */
    parse arg str, old, new
    p = pos(old, str)
    if (p > 0) then
        str = left(str, p-1)||new||substr(str,p+length(old))
return str

